#include "IRImagerHandler.h"
#include <string.h>
#include <iostream>

using namespace std;

IRImagerHandler::IRImagerHandler(IRImager* imager)
{
  _imager    = imager;
  _imager->setClient(this);
  _bufferRaw = new unsigned char[imager->getRawBufferSize()];
  _thermal   = NULL;
  _yuyv      = NULL;
  _display   = NULL;

  _iBuilder.setPaletteScalingMethod(evo::eMinMax);
  _iBuilder.setPalette(evo::eIron);
}

IRImagerHandler::~IRImagerHandler()
{
  if (_thermal) delete[] _thermal;
  if (_yuyv)    delete[] _yuyv;
  if (_display) delete _display;
  delete[] _bufferRaw;
}

void IRImagerHandler::run()
{
  _display = new VideoDisplay(_imager->getWidth(), _imager->getHeight());
  _display->show();
}

void IRImagerHandler::onThermalFrame(unsigned short* thermal, unsigned int w, unsigned int h, IRFrameMetadata meta, void* arg)
{
  _iBuilder.setData(w, h, thermal);
  if (_thermal == NULL)
    _thermal = new unsigned char[_iBuilder.getStride() * h * 3];

  _iBuilder.convertTemperatureToPaletteImage(_thermal);

  _display->drawCapture(0, 0, _iBuilder.getStride(), h, 24, _thermal);
}

void IRImagerHandler::onVisibleFrame(unsigned char* yuyv, unsigned int w, unsigned int h, IRFrameMetadata meta, void* arg)
{
  if (_yuyv == NULL) _yuyv = new unsigned char[w*h * 2];
  memcpy(_yuyv, yuyv, 2 * w*h*sizeof(*yuyv));
}

void IRImagerHandler::onFlagStateChange(unsigned int flagstate)
{
  cout << "Flag state: " << flagstate << endl;
}

void IRImagerHandler::onRawFrame(unsigned char* data, int size)
{
  double fps;
  if (_frc.trigger(&fps))
    cout << "Frame rate: " << fps << " fps" << endl;
  _imager->process(data);
}

